
import numpy as np
from tqdm import tqdm

from src.imports.import_profile import import_profile

from itertools import combinations


from src.imports.import_profile import (
    import_distances, import_coordinates, import_radius,
)

from src.imports.import_clustering_sets import import_clustering_sets


if __name__ == "__main__":

    num_tests = 100
    num_voters = 1000
    num_candidates = 100
    lower_radius = 0.015
    upper_radius = 0.15

    num_clusters = 5

    method = 'hierarchical_minavg'

    base_distances = ['norm_hamming', 'geom_hamming', 'rms_hamming',
                      'jaccard', 'geom_jaccard', 'rms_jaccard']


    for base_distance in base_distances:

        # IMPORT CLUSTERS
        c_sets_path = f"output/sampled/euclidean_1d/{method}_{base_distance}_c_sets_{num_clusters}_{num_voters}_{num_candidates}_{lower_radius}_{upper_radius}.txt"
        c_sets = import_clustering_sets(c_sets_path)

        output = []
        for t in tqdm(range(num_tests)):
            clusters = c_sets[str(t)]

            path = f'data/sampled/euclidean_1d/profiles/profile_{num_voters}_{num_candidates}_{t}_{lower_radius}_{upper_radius}'
            P = import_profile(path)

            # IMPORT COORDINATES
            c_points_path = f'data/sampled/euclidean_1d/coordinates/c_points_{num_voters}_{num_candidates}_{t}_{lower_radius}_{upper_radius}.csv'
            c_coordinates = import_coordinates(c_points_path)

            mistake_ctr = 0
            all_ctr = 0
            for cluster in clusters.values():
                for pair in combinations(cluster, 2):
                    a = c_coordinates[pair[0]]
                    b = c_coordinates[pair[1]]

                    for j in range(num_candidates):
                        if j not in cluster:
                            p = c_coordinates[j]

                            all_ctr += 1
                            if (a < p and p < b) or (b < p and p < a):
                                mistake_ctr += 1

            output.append(mistake_ctr/all_ctr)
        print('base_distance:', base_distance)
        print(output)
        output = np.array(output)
        print('avg:', round(np.mean(output), 4))
        print('std:', round(np.std(output), 4))
